﻿CREATE PROCEDURE [App].[NVCC_usp_GetFacilityByVisnId]
	

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--=================================================================================
--Requestor				: REFDOC
--Author                : Lavanya Epuri
--Object/SP Name		: NVCC_usp_GetFacilityByVisnId
--SERVER				: 
--Data Base				: CC_REFDOC
--Schema				: app
--Report				: N/A
--Folder				: N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 12-12-2017

--
--Purpose               : Retrieve list of facilites for selected Visn
--=================================================================================
--Uses: CDWWork.Dim.Sta3n
--Uses: App.udf_StationName(Sta3n) function

BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	SELECT 
		Sta3n AS FacilityID
		,(App.udf_StationName(Sta3n)) AS FacilityName 
		,VISNFY17 AS VISN		
	FROM CDWWork.Dim.Sta3n 
	where Sta3n > 0
	and (App.udf_StationName(Sta3n)) IS NOT NULL
	order by VISN
      
END;
